/*== MT8820 Radio Communication Analyzer ===============*/
/*    Modification History:
     01 Sep 2003 -  [V3.0], Anritsu MCA1, New Released. 

*/
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/

#ifndef  __MT8820_HEADER_WCDMA
#define __MT8820_HEADER_WCDMA

#include <visatype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/

#define VI_ERROR_FILE_OPEN              (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_FILE_WRITE             (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_SECURITY_CODE          (_VI_ERROR+0x3FFC0802L)
#define VI_ERROR_INTERPRETING_RESPONSE  (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_STAMP                  (_VI_ERROR+0x3FFC0805L)
#define VI_ERROR_OUTOF_RANGE            (_VI_ERROR+0x3FFC0806L)

/*****************************************************************************/
/*= Define Other useful values here             =============================*/
/*****************************************************************************/

#define BUFFER_SIZE     256L         /* File I/O buffer size */
#define SMALL_BUFFER BUFFER_SIZE - 1 /* I/O buffer for Scan function */
#define LARGE_BUFFER_SIZE     4096L         /* File I/O buffer size */
#define LARGE_BUFFER_M1 LARGE_BUFFER_SIZE - 1 /* I/O buffer for Scan function */
#define MAX_CMD_LENGTH  256L
#define AUMT8820_FREQUENCY_UNIT_HZ   0
#define AUMT8820_FREQUENCY_UNIT_KHZ  1
#define AUMT8820_FREQUENCY_UNIT_MHZ  2
#define AUMT8820_FREQUENCY_UNIT_GHZ  3

/*****************************************************************************/
/*= Define Enumeration Constants here             ===========================*/
/*****************************************************************************/

#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_ALL                     0
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_POWER                   1
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_FREQUENCY               2
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_OCCUPIED_BANDWIDTH      3
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_SPECTRUM_EMISSION_MASK  4
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_ADJACENT_CHANNEL_POWER  5
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_MODULATION_ANALYSIS     6
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_PEAK_CODE_DOMAIN_ERROR  7
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_BIT_ERROR_RATE          8
#define AUMT8820_ALL_MEASUREMENT_RESULTS_WCDMA_BLOCK_ERROR_RATE        9

#define AUMT8820_ACTIVE_MARKER_MARKER_1      0
#define AUMT8820_ACTIVE_MARKER_MARKER_2      1

#define AUMT8820_ADJACENT_CHANNEL_POWER_MODE_ON      0
#define AUMT8820_ADJACENT_CHANNEL_POWER_MODE_OFF     1

#define AUMT8820_DOWNLINK_AICH_OUTPUTS_AICH      0
#define AUMT8820_DOWNLINK_AICH_NO_OUTPUT         1

#define AUMT8820_AUDIO_INPUT_OUTPUT_CONNECTOR_AF       0
#define AUMT8820_AUDIO_INPUT_OUTPUT_CONNECTOR_HANDSET  1

#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_POWER                   0
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_FREQUENCY               1
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_OCCUPIED_BANDWIDTH      2
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_SPECTRUM_EMISSION_MASK  3
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_ADJACENT_CHANNEL_POWER  4
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_MODULATION_ANALYSIS     5
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_PEAK_CODE_DOMAIN_ERROR  6
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_BIT_ERROR_RATE          7
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_RESULTS_WCDMA_BLOCK_ERROR_RATE        8

#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_ITEMS_WCDMA_1_ON      0
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_ITEMS_WCDMA_1_OFF     1
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_ITEMS_WCDMA_2_ON      0
#define AUMT8820_ALL_FUNDAMENTAL_MEASUREMENT_ITEMS_WCDMA_2_OFF     1

#define AUMT8820_AUTHENTICATION_KEY_VALUE_1      0
#define AUMT8820_AUTHENTICATION_KEY_VALUE_2      1
#define AUMT8820_AUTHENTICATION_KEY_VALUE_3      2
#define AUMT8820_AUTHENTICATION_KEY_VALUE_4      3

#define AUMT8820_AUTHENTICATION_KEY_ALL_VALUE_1      0
#define AUMT8820_AUTHENTICATION_KEY_ALL_VALUE_2      1
#define AUMT8820_AUTHENTICATION_KEY_ALL_VALUE_3      2
#define AUMT8820_AUTHENTICATION_KEY_ALL_VALUE_4      3

#define AUMT8820_AUX_EXTERNAL_LOSS_MODE_ON      0
#define AUMT8820_AUX_EXTERNAL_LOSS_MODE_OFF     1
#define AUMT8820_AUX_EXTERNAL_LOSS_MODE_COMMON  2

#define AUMT8820_CARRIER_FREQ_ERROR_UNIT_HZ      0
#define AUMT8820_CARRIER_FREQ_ERROR_UNIT_PPM     1

#define AUMT8820_FILTERED_POWER_UNIT_DBM      0
#define AUMT8820_FILTERED_POWER_UNIT_WATT     1

#define AUMT8820_ADJACENT_CHAN_POWER_OFFSET_M10MHZ     0
#define AUMT8820_ADJACENT_CHAN_POWER_OFFSET_M5MHZ      1
#define AUMT8820_ADJACENT_CHAN_POWER_OFFSET_P5MHZ      2
#define AUMT8820_ADJACENT_CHAN_POWER_OFFSET_P10MHZ     3

#define AUMT8820_ADJACENT_CHAN_POWER_UNIT_DB      0
#define AUMT8820_ADJACENT_CHAN_POWER_UNIT_DBM     1
#define AUMT8820_ADJACENT_CHAN_POWER_UNIT_WATT    2

#define AUMT8820_TX_POWER_UNIT_DBM      0
#define AUMT8820_TX_POWER_UNIT_WATT     1

#define AUMT8820_AWGN_OUTPUT_MODE_ON       0
#define AUMT8820_AWGN_OUTPUT_MODE_OFF      1

#define AUMT8820_BIT_ERROR_RATE_WCDMA_RATIO      0
#define AUMT8820_BIT_ERROR_RATE_WCDMA_PERCENT    1

#define AUMT8820_BIT_ERROR_RATE_JUDGEMENT_PASS       0
#define AUMT8820_BIT_ERROR_RATE_JUDGEMENT_FAIL       1
#define AUMT8820_BIT_ERROR_RATE_JUDGEMENT_NOT_JUDGED 2
#define AUMT8820_BIT_ERROR_RATE_JUDGEMENT_PASSED     0

#define AUMT8820_BIT_ERROR_RATE_INPUT_DATA_CLOCK_EDGE_RISE      0
#define AUMT8820_BIT_ERROR_RATE_INPUT_DATA_CLOCK_EDGE_FALL      1

#define AUMT8820_BIT_ERROR_RATE_INPUT_POLARITY_POSITIVE      0
#define AUMT8820_BIT_ERROR_RATE_INPUT_POLARITY_NEGATIVE      1

#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_MODE_ON      0
#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_MODE_OFF     1

#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_INPUT_RF_LOOP_BACK      0
#define AUMT8820_BIT_ERROR_RATE_MEASUREMENT_INPUT_EXTERNAL_INPUT    1

#define AUMT8820_BLOCK_ERROR_RATE_WCDMA_RATIO      0
#define AUMT8820_BLOCK_ERROR_RATE_WCDMA_PERCENT    1

#define AUMT8820_BLOCK_ERROR_RATE_JUDGEMENT_PASS    0
#define AUMT8820_BLOCK_ERROR_RATE_JUDGEMENT_FAIL    1

#define AUMT8820_BLOCK_ERROR_RATE_MEASUREMENT_MODE_ON      0
#define AUMT8820_BLOCK_ERROR_RATE_MEASUREMENT_MODE_OFF     1

#define AUMT8820_CALL_DROP_ON      0
#define AUMT8820_CALL_DROP_OFF     1

#define AUMT8820_CALL_PROCESSING_WCDMA_OFF                0
#define AUMT8820_CALL_PROCESSING_WCDMA_IDLE               1
#define AUMT8820_CALL_PROCESSING_WCDMA_IDLE_REG           2
#define AUMT8820_CALL_PROCESSING_WCDMA_REGISTRATION       3
#define AUMT8820_CALL_PROCESSING_WCDMA_ORIGINATION        4
#define AUMT8820_CALL_PROCESSING_WCDMA_TERMINATION        5
#define AUMT8820_CALL_PROCESSING_WCDMA_COMMUNICATION      6
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_1         7
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_1_OPEN    8
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_1_CLOSE   9
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_2         10
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_2_OPEN    11
#define AUMT8820_CALL_PROCESSING_WCDMA_LOOPMODE_2_CLOSE   12
#define AUMT8820_CALL_PROCESSING_WCDMA_HANDOVER           13
#define AUMT8820_CALL_PROCESSING_WCDMA_NW_RELEASE         14
#define AUMT8820_CALL_PROCESSING_WCDMA_UE_RELEASE         15
#define AUMT8820_CALL_PROCESSING_WCDMA_OTHER              16

#define AUMT8820_CALL_PROCESSING_ON      0
#define AUMT8820_CALL_PROCESSING_OFF     1

#define AUMT8820_CALL_PROCESSING_FLAG_EXECUTED      0
#define AUMT8820_CALL_PROCESSING_FLAG_NOT_EXECUTED  1

#define AUMT8820_CHANNEL_CODING_OBJECT_REFERENCE_MEASUREMENT_CHANNEL   0
#define AUMT8820_CHANNEL_CODING_OBJECT_VOICE_DATA                      1
#define AUMT8820_CHANNEL_CODING_OBJECT_AUDIO_VISUAL                    2
#define AUMT8820_CHANNEL_CODING_OBJECT_PACKET                          3

#define AUMT8820_AICH_CONDITION_OF_RETURNING_ACKNOWLEDGE_ON      0
#define AUMT8820_AICH_CONDITION_OF_RETURNING_ACKNOWLEDGE_OFF     1

#define AUMT8820_CPICH_DOWNLINK_ON      0
#define AUMT8820_CPICH_DOWNLINK_OFF     1

#define AUMT8820_DCCH_DATA_PATTERN_ALL_0S             0
#define AUMT8820_DCCH_DATA_PATTERN_ALL_1S             1
#define AUMT8820_DCCH_DATA_PATTERN_PN9                2
#define AUMT8820_DCCH_DATA_PATTERN_PN15               3
#define AUMT8820_DCCH_DATA_PATTERN_SIGNALING_CONTROL  4

#define AUMT8820_DPCH_DOWNLINK_CHANNEL_ON      0
#define AUMT8820_DPCH_DOWNLINK_CHANNEL_OFF     1

#define AUMT8820_EXTERNAL_LOSS_MODE_ON      0
#define AUMT8820_EXTERNAL_LOSS_MODE_OFF     1
#define AUMT8820_EXTERNAL_LOSS_MODE_COMMON  2

#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_ALL_ZEROS   0
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_ALL_ONES    1
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_PN9         2
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_PN15        3
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_ECHO        4
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_VOICE       5
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_NO_DATA     6
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_EXT_PPP     7
#define AUMT8820_DIGITAL_TRAFFIC_CHANNEL_DATA_PATTERN_EXT_IP      8

#define AUMT8820_FREQUENCY_ERROR_MEASUREMENT_MODE_ON      0
#define AUMT8820_FREQUENCY_ERROR_MEASUREMENT_MODE_OFF     1

#define AUMT8820_TPC_COMMAND_TYPE_B      0
#define AUMT8820_TPC_COMMAND_TYPE_C      1
#define AUMT8820_TPC_COMMAND_TYPE_D      2
#define AUMT8820_TPC_COMMAND_TYPE_E      3
#define AUMT8820_TPC_COMMAND_TYPE_F      4
#define AUMT8820_TPC_COMMAND_TYPE_G      5
#define AUMT8820_TPC_COMMAND_TYPE_H      6

#define AUMT8820_TPC_COMMAND_ALL_ZEROS      0
#define AUMT8820_TPC_COMMAND_ALL_ONES       1
#define AUMT8820_TPC_COMMAND_ALTERNATE      2

#define AUMT8820_TPC_COMMAND_MODE_DEFAULT       0
#define AUMT8820_TPC_COMMAND_MODE_USER_DEFINED  1

#define AUMT8820_TPC_TEST_STEP_A      0
#define AUMT8820_TPC_TEST_STEP_B      1
#define AUMT8820_TPC_TEST_STEP_C      2
#define AUMT8820_TPC_TEST_STEP_D      3
#define AUMT8820_TPC_TEST_STEP_E      4
#define AUMT8820_TPC_TEST_STEP_F      5
#define AUMT8820_TPC_TEST_STEP_G      6
#define AUMT8820_TPC_TEST_STEP_H      7

#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_COMMON_PARAMETER     0
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_PHYSICAL_CHANNEL     1
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_CALL_PROCESSING      2
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_TX_MEASURE           3
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_RX_MEASURE           4
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_FUNDAMENTAL          5
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_AUDIO                6
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_TIME_DOMAIN          7
#define AUMT8820_PARAMETER_ITEMS_DISPLAYED_WCDMA_SPECTRUM_MONITOR     8

#define AUMT8820_PARAMETER_OPTION_WCDMA_STANDARD       0
#define AUMT8820_PARAMETER_OPTION_WCDMA_DETAIL         1
#define AUMT8820_PARAMETER_OPTION_WCDMA_NON_DISPLAYED  2

#define AUMT8820_LONG_SPAN_CODE_SEARCH_ON      0
#define AUMT8820_LONG_SPAN_CODE_SEARCH_OFF     1

#define AUMT8820_RF_LEVEL_OUTPUT_MODE_ON      0
#define AUMT8820_RF_LEVEL_OUTPUT_MODE_OFF     1

#define AUMT8820_LEVEL_CONTINUOUS_ON      0
#define AUMT8820_LEVEL_CONTINUOUS_OFF     1

#define AUMT8820_MODULATION_ANALYSIS_STORAGE_MODE_MAXIMUM      0
#define AUMT8820_MODULATION_ANALYSIS_STORAGE_MODE_MINIMUM      1
#define AUMT8820_MODULATION_ANALYSIS_STORAGE_MODE_LATEST       2
#define AUMT8820_MODULATION_ANALYSIS_STORAGE_MODE_AVERAGE      3

#define AUMT8820_DOWNLINK_RAB_RATE_MAXIMUM_12_2_KBPS     0
#define AUMT8820_DOWNLINK_RAB_RATE_MAXIMUM_64_KBPS       1
#define AUMT8820_DOWNLINK_RAB_RATE_MAXIMUM_144_KBPS      2
#define AUMT8820_DOWNLINK_RAB_RATE_MAXIMUM_384_KBPS      3

#define AUMT8820_FUNDAMENTAL_MEASUREMENT_MODE_NORMAL    0
#define AUMT8820_FUNDAMENTAL_MEASUREMENT_MODE_FAST      1

#define AUMT8820_MEASUREMENT_OBJECT_WCDMA_RACHTMSK  0
#define AUMT8820_MEASUREMENT_OBJECT_WCDMA_RACH      1
#define AUMT8820_MEASUREMENT_OBJECT_WCDMA_ILPC      2
#define AUMT8820_MEASUREMENT_OBJECT_WCDMA_OTHER     3

#define AUMT8820_MARKER_1_MODE_ON      0
#define AUMT8820_MARKER_1_MODE_OFF     1

#define AUMT8820_MARKER_2_MODE_ON      0
#define AUMT8820_MARKER_2_MODE_OFF     1

#define AUMT8820_MODULATION_ANALYSIS_MARKER_ON   0
#define AUMT8820_MODULATION_ANALYSIS_MARKER_OFF  1

#define AUMT8820_SPECTRUM_EMISSION_MASK_MARKER_MODE_ON   0
#define AUMT8820_SPECTRUM_EMISSION_MASK_MARKER_MODE_OFF  1

#define AUMT8820_MARKER_POSITION_ACTIVE        0
#define AUMT8820_MARKER_POSITION_MARKER_1      1
#define AUMT8820_MARKER_POSITION_MARKER_2      2

#define AUMT8820_SPECTRUM_EMISSION_MARKER_UNIT_DB      0
#define AUMT8820_SPECTRUM_EMISSION_MARKER_UNIT_DBM     1
#define AUMT8820_SPECTRUM_EMISSION_MARKER_UNIT_WATT    2

#define AUMT8820_MARKER_TYPE_NORMAL    0
#define AUMT8820_MARKER_TYPE_SLOT      1

#define AUMT8820_MODULATION_ANALYSIS_MEASUREMENT_MODE_ON      0
#define AUMT8820_MODULATION_ANALYSIS_MEASUREMENT_MODE_OFF     1

#define AUMT8820_MODULATION_ANALYSIS_WAVEFORM_EVM_WAVEFORM           0
#define AUMT8820_MODULATION_ANALYSIS_WAVEFORM_PHASE_ERROR_WAVEFORM   1
#define AUMT8820_MODULATION_ANALYSIS_WAVEFORM_MAGNITUDE_ERROR        2
																  
#define AUMT8820_NOISE_CALIBRATION_FOR_TDM_ON      0
#define AUMT8820_NOISE_CALIBRATION_FOR_TDM_OFF     1

#define AUMT8820_OCCUPIED_BANDWIDTH_FREQUENCY_MODE_UPPER      0
#define AUMT8820_OCCUPIED_BANDWIDTH_FREQUENCY_MODE_LOWER      1
#define AUMT8820_OCCUPIED_BANDWIDTH_FREQUENCY_MODE_CENTER     2

#define AUMT8820_OCCUPIED_BANDWIDTH_DETECT_MODE_POSITIVE      0
#define AUMT8820_OCCUPIED_BANDWIDTH_DETECT_MODE_NEGATIVE      1
#define AUMT8820_OCCUPIED_BANDWIDTH_DETECT_MODE_SAMPLE        2
#define AUMT8820_OCCUPIED_BANDWIDTH_DETECT_MODE_AVERAGE       3

#define AUMT8820_OCCUPIED_BANDWIDTH_MEASUREMENT_MODE_ON      0
#define AUMT8820_OCCUPIED_BANDWIDTH_MEASUREMENT_MODE_OFF     1

#define AUMT8820_DOWNLINK_OCNS_ON      0
#define AUMT8820_DOWNLINK_OCNS_OFF     1

#define AUMT8820_OUTPUT_LEVEL_UNIT_DB    0
#define AUMT8820_OUTPUT_LEVEL_UNIT_DBM   1
#define AUMT8820_OUTPUT_LEVEL_UNIT_DBU   2

#define AUMT8820_DOWNLINK_PCCPCH_ON      0
#define AUMT8820_DOWNLINK_PCCPCH_OFF     1

#define AUMT8820_PEAK_CODE_DOMAIN_ERROR_MEASUREMENT_MODE_ON      0
#define AUMT8820_PEAK_CODE_DOMAIN_ERROR_MEASUREMENT_MODE_OFF     1

#define AUMT8820_DOWNLINK_PICH_ON      0
#define AUMT8820_DOWNLINK_PICH_OFF     1

#define AUMT8820_POWER_MEASUREMENT_MODE_ON      0
#define AUMT8820_POWER_MEASUREMENT_MODE_OFF     1

#define AUMT8820_MEASUREMENT_STATUS_NORMAL_END      0
#define AUMT8820_MEASUREMENT_STATUS_1_UNDEFINED     1
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_OVER      2
#define AUMT8820_MEASUREMENT_STATUS_LEVEL_UNDER     3
#define AUMT8820_MEASUREMENT_STATUS_MEAS_DISABLE    4
#define AUMT8820_MEASUREMENT_STATUS_SYNC_WORD_DET_DISABLE      5
#define AUMT8820_MEASUREMENT_STATUS_SYNC_ESTABLISHING          6
#define AUMT8820_MEASUREMENT_STATUS_SYNC_ERROR      7
#define AUMT8820_MEASUREMENT_STATUS_8_UNDEFINED     8
#define AUMT8820_MEASUREMENT_STATUS_NOT_MEASURED    9
#define AUMT8820_MEASUREMENT_STATUS_10_UNDEFINED    10
#define AUMT8820_MEASUREMENT_STATUS_11_UNDEFINED    11
#define AUMT8820_MEASUREMENT_STATUS_TX_MEAS_TIMEOUT 12
#define AUMT8820_MEASUREMENT_STATUS_RX_MEAS_TIMEOUT 13

#define AUMT8820_DOWNLINK_SCCPCH_ON      0
#define AUMT8820_DOWNLINK_SCCPCH_OFF     1

#define AUMT8820_DOWNLINK_SCH_ON      0
#define AUMT8820_DOWNLINK_SCH_OFF     1

#define AUMT8820_ACTIVE_WINDOW_WCDMA_PARAMETER         0
#define AUMT8820_ACTIVE_WINDOW_WCDMA_FUNDAMENTAL       1
#define AUMT8820_ACTIVE_WINDOW_WCDMA_SEQUENCE_MONITOR  2
#define AUMT8820_ACTIVE_WINDOW_WCDMA_SPECTRUM_MONITOR  3
#define AUMT8820_ACTIVE_WINDOW_WCDMA_UE_REPORT         4
#define AUMT8820_ACTIVE_WINDOW_WCDMA_TIME_DOMAIN       5
#define AUMT8820_ACTIVE_WINDOW_WCDMA_SLOT_POWER_LIST   6

#define AUMT8820_SCREEN_SELECT_WCDMA_FUNDAMENTAL       0
#define AUMT8820_SCREEN_SELECT_WCDMA_TIME_DOMAIN       1
#define AUMT8820_SCREEN_SELECT_WCDMA_PARAMETER_SAVE    2
#define AUMT8820_SCREEN_SELECT_WCDMA_PARAMETER_RECALL  3
#define AUMT8820_SCREEN_SELECT_WCDMA_SYSTEM_CONFIG     4
#define AUMT8820_SCREEN_SELECT_WCDMA_SYSTEM_INFO       5
#define AUMT8820_SCREEN_SELECT_WCDMA_SEQUENCE_MONITOR  6
#define AUMT8820_SCREEN_SELECT_WCDMA_SPECTRUM_MONITOR  7

#define AUMT8820_SEQUENTIAL_OUTPUT_MODE_ON      0
#define AUMT8820_SEQUENTIAL_OUTPUT_MODE_OFF     1

#define AUMT8820_SLOT_LIST_MODE_ON    0
#define AUMT8820_SLOT_LIST_MODE_OFF   1

#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_JUDGMENT_PASS        0
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_JUDGMENT_FAIL        1
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_JUDGMENT_NOT_JUDGED  2

#define AUMT8820_SPECTRUM_EMISSION_MASK_LIMIT_NO_ADD_LIMIT 0
#define AUMT8820_SPECTRUM_EMISSION_MASK_LIMIT_WCDMA_1900   1

#define AUMT8820_SPECTRUM_EMISSION_DETECTION_MODE_POSITIVE   0
#define AUMT8820_SPECTRUM_EMISSION_DETECTION_MODE_NEGATIVE   1
#define AUMT8820_SPECTRUM_EMISSION_DETECTION_MODE_SAMPLE     2
#define AUMT8820_SPECTRUM_EMISSION_DETECTION_MODE_AVERAGE    3

#define AUMT8820_SPECTRUM_EMISSION_MASK_MEASUREMENT_MODE_ON    0
#define AUMT8820_SPECTRUM_EMISSION_MASK_MEASUREMENT_MODE_OFF   1

#define AUMT8820_SPECTRUM_MONITOR_DETECTION_MODE_PEAK     0
#define AUMT8820_SPECTRUM_MONITOR_DETECTION_MODE_RMS      1

#define AUMT8820_SPECTRUM_MONITOR_FREQUENCY_SPAN_5_MHZ    0
#define AUMT8820_SPECTRUM_MONITOR_FREQUENCY_SPAN_25_MHZ   1

#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_COMPLETED      0
#define AUMT8820_SYNCHRONOUS_SINGLE_SWEEP_EXECUTING      1

#define AUMT8820_SYNC_MARKER_1_AND_2_ON      0
#define AUMT8820_SYNC_MARKER_1_AND_2_OFF     1

#define AUMT8820_WINDOW_SELECT_WCDMA_PARAMETER      0
#define AUMT8820_WINDOW_SELECT_WCDMA_FUNDAMENTAL    1
#define AUMT8820_WINDOW_SELECT_WCDMA_UE_REPORT      2
#define AUMT8820_WINDOW_SELECT_WCDMA_SYSTEM_CONFIG  3

#define AUMT8820_TAG_WCDMA_PARAM_COMMON_PARAMETER      0
#define AUMT8820_TAG_WCDMA_PARAM_PHYSICAL_CHANNEL      1
#define AUMT8820_TAG_WCDMA_PARAM_CALL_PROCESSING       2
#define AUMT8820_TAG_WCDMA_PARAM_TX_MEASUREMENT        3
#define AUMT8820_TAG_WCDMA_PARAM_RX_MEASUREMENT        4
#define AUMT8820_TAG_WCDMA_PARAM_FUNDAMENTAL_MEAS      5
#define AUMT8820_TAG_WCDMA_PARAM_TIME_DOMAIN_MEAS      6
#define AUMT8820_TAG_WCDMA_PARAM_SPECTRUM_PARAMETER    7
#define AUMT8820_TAG_WCDMA_PARAM_AUDIO_PARAMETER       8
#define AUMT8820_TAG_WCDMA_FUND_POWER_MEASUREMENT      9
#define AUMT8820_TAG_WCDMA_FUND_FREQUENCY_ERROR        10
#define AUMT8820_TAG_WCDMA_FUND_OCCUPIED_BANDWIDTH     11
#define AUMT8820_TAG_WCDMA_FUND_SPECTRUM_EMISSION_MASK 12
#define AUMT8820_TAG_WCDMA_FUND_ADJ_CHANNEL_POWER      13
#define AUMT8820_TAG_WCDMA_FUND_MODULATION_ANALYSIS    14
#define AUMT8820_TAG_WCDMA_FUND_PEAK_CODE_DOMAIN_ERROR 15
#define AUMT8820_TAG_WCDMA_FUND_BIT_ERROR_RATE         16
#define AUMT8820_TAG_WCDMA_FUND_BLOCK_ERROR_RATE       17
#define AUMT8820_TAG_WCDMA_UE_REPORT_UE_REPORT         18
#define AUMT8820_TAG_WCDMA_SYSTEM_CFG_COMMON           19
#define AUMT8820_TAG_WCDMA_SYSTEM_CFG_PHONE1           20

#define AUMT8820_TIME_DOMAIN_RRC_FILTER_ON      0
#define AUMT8820_TIME_DOMAIN_RRC_FILTER_OFF     1

#define AUMT8820_TEMPLATE_SPECTRUM_EMISSION_MASK     0
#define AUMT8820_TEMPLATE_POWER                      1
#define AUMT8820_TEMPLATE_NONE                       2
#define AUMT8820_TEMPLATE_EMPTY                      3

#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_OFFSET_2_5MHZ_RBW_30KHZ      0
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_OFFSET_3_5MHZ_RBW_30KHZ      1
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_OFFSET_3_5MHZ_RBW_1MHZ       2
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_OFFSET_7_5MHZ_RBW_1MHZ       3
#define AUMT8820_SPECTRUM_EMISSION_MASK_TEMPLATE_OFFSET_8_5MHZ_RBW_1MHZ       4

#define AUMT8820_LOOPBACK_MODE_OFF      0
#define AUMT8820_LOOPBACK_MODE_MODE1    1
#define AUMT8820_LOOPBACK_MODE_MODE2    2

#define AUMT8820_POWER_CONTROL_ALGORITHM_1      0
#define AUMT8820_POWER_CONTROL_ALGORITHM_2      1

#define AUMT8820_POWER_CONTROL_BIT_PATTERN_ALL_0         0
#define AUMT8820_POWER_CONTROL_BIT_PATTERN_ALL_1         1
#define AUMT8820_POWER_CONTROL_BIT_PATTERN_ALT_0_AND_1   2
#define AUMT8820_POWER_CONTROL_BIT_PATTERN_ILPC          3
#define AUMT8820_POWER_CONTROL_BIT_PATTERN_USER_DEFINED  4

#define AUMT8820_TPC_STEP_SIZE_1_DBM      0
#define AUMT8820_TPC_STEP_SIZE_2_DBM      1

#define AUMT8820_TRIGGER_SOURCE_VIDEO           0
#define AUMT8820_TRIGGER_SOURCE_RISING_VIDEO    1
#define AUMT8820_TRIGGER_SOURCE_FALLING _VIDEO  2
#define AUMT8820_TRIGGER_SOURCE_INTERNAL        3
#define AUMT8820_TRIGGER_SOURCE_EXTERNAL        4
#define AUMT8820_TRIGGER_SOURCE_FREE_RUN        5

#define AUMT8820_UPLINK_DPCH_SCRAMBLING_CODE_TYPE_LONG      0
#define AUMT8820_UPLINK_DPCH_SCRAMBLING_CODE_TYPE_SHORT     1

#define AUMT8820_UPLINK_EXTERNAL_LOSS_ON      0
#define AUMT8820_UPLINK_EXTERNAL_LOSS_OFF     1
#define AUMT8820_UPLINK_EXTERNAL_LOSS_COMMON  2

#define AUMT8820_DOWNLINK_CHANNEL_LEVEL_UNIT_TOTAL_POWER      0
#define AUMT8820_DOWNLINK_CHANNEL_LEVEL_UNIT_DPCH             1

#define AUMT8820_VOLTAGE_DISPLAY_OPEN           0
#define AUMT8820_VOLTAGE_DISPLAY_TERMINATION    1

#define AUMT8820_VOICE_CHANNEL_SUBFLOW_1      0
#define AUMT8820_VOICE_CHANNEL_SUBFLOW_2      1
#define AUMT8820_VOICE_CHANNEL_SUBFLOW_3      2

#define AUMT8820_MODULATION_ANALYSIS_VERTICAL_SCALE_RANGE_5      0
#define AUMT8820_MODULATION_ANALYSIS_VERTICAL_SCALE_RANGE_10     1
#define AUMT8820_MODULATION_ANALYSIS_VERTICAL_SCALE_RANGE_20     2
#define AUMT8820_MODULATION_ANALYSIS_VERTICAL_SCALE_RANGE_50     3
#define AUMT8820_MODULATION_ANALYSIS_VERTICAL_SCALE_RANGE_100    4

#define AUMT8820_VIEW_WINDOW_OCCUPIED_BANDWIDTH     0
#define AUMT8820_VIEW_WINDOW_SPECTRUM_EMISSION_MASK 1
#define AUMT8820_VIEW_WINDOW_MODULATION_ANALYSIS    2
#define AUMT8820_VIEW_WINDOW_NONE                   3
#define AUMT8820_VIEW_WINDOW_EMPTY                  4

#define AUMT8820_WINDOW_SIZE_100     0
#define AUMT8820_WINDOW_SIZE_70      1
#define AUMT8820_WINDOW_SIZE_50      2
#define AUMT8820_WINDOW_SIZE_30      3

#define AUMT8820_SPECTRUM_MONITOR_ZONE_MARKER_ON      0
#define AUMT8820_SPECTRUM_MONITOR_ZONE_MARKER_OFF     1

#define AUMT8820_RRC_FILTERING_MODE_ON      0
#define AUMT8820_RRC_FILTERING_MODE_OFF     1

//#error In WCDMA!
/*****************************************************************************/
/*= Define Function Prototypes here             =============================*/
/*****************************************************************************/
ViStatus _VI_FUNC AuMT8820_All_Fundamental_Measurement_Results_WCDMA(ViSession instrSession, ViChar _VI_FAR results[], ViInt32 _VI_FAR tag);
ViStatus _VI_FUNC AuMT8820_Band_Calibration_WCDMA(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_BCCH_Signaling(ViSession instrSession, ViReal64 _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Bit_Error_Rate_Count_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Bit_Error_Rate_Judgement(ViSession instrSession, ViInt32 _VI_FAR *judgement);
ViStatus _VI_FUNC AuMT8820_Bit_Error_Rate_Transmit(ViSession instrSession, ViInt32 _VI_FAR *transmitted_Bits);
ViStatus _VI_FUNC AuMT8820_Bit_Error_Rate_Ratio_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Block_Error_Rate_Judgement(ViSession instrSession, ViInt32 _VI_FAR *judgement);
ViStatus _VI_FUNC AuMT8820_Block_Error_Rate_Transmit(ViSession instrSession, ViInt32 _VI_FAR *transmitted_Blocks);
ViStatus _VI_FUNC AuMT8820_Block_Error_Rate_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *ratio);
ViStatus _VI_FUNC AuMT8820_Call_Processing_Error_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *code, ViInt32 _VI_FAR *error);
ViStatus _VI_FUNC AuMT8820_Call_Processing_Result_WCDMA(ViSession instrSession, ViInt32 code, ViInt32 _VI_FAR *flag, ViInt32 _VI_FAR *err_code);
ViStatus _VI_FUNC AuMT8820_Call_Processing_Status_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Continuous_Mode_Measure(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Delete_Slot_from_List(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Delete_Slot_from_List_Range(ViSession instrSession, ViInt32 slotn, ViInt32 slotm);
ViStatus _VI_FUNC AuMT8820_Full_Calibration_WCDMA(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Refresh_Call_Status_WCDMA(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Register_Slot_Into_List_Range(ViSession instrSession, ViInt32 slotn, ViInt32 slotm);
ViStatus _VI_FUNC AuMT8820_Single_Sweep(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Start_Call(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Stop_Call(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Stop_Measurement_WCDMA(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Sweep_and_Page(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Template_Close_WCDMA(ViSession instrSession, ViInt32  template);
ViStatus _VI_FUNC AuMT8820_View_Window_Close(ViSession instrSession, ViInt32 view);
ViStatus _VI_FUNC AuMT8820_Set_Active_Marker(ViSession instrSession, ViInt32 marker);
ViStatus _VI_FUNC AuMT8820_Get_Active_Marker(ViSession instrSession,  ViInt32  _VI_FAR *marker);
ViStatus _VI_FUNC AuMT8820_Set_Active_Window_WCDMA(ViSession instrSession, ViInt32 window);
ViStatus _VI_FUNC AuMT8820_Get_Active_Window_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *window);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power(ViSession instrSession, ViInt32 offset, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power_Average(ViSession instrSession, ViInt32 offset, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power_Maximum(ViSession instrSession, ViInt32 offset, ViInt32 unit,  ViReal64  _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power_Minimum(ViSession instrSession, ViInt32 offset, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Adjacent_Channel_Power_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Adjacent_Channel_Power_Total(ViSession instrSession, ViInt32 offset, ViInt32 unit, ViReal64 _VI_FAR *avg_level, ViReal64 _VI_FAR *max_level, ViReal64 _VI_FAR *min_level);
ViStatus _VI_FUNC AuMT8820_Set_AF_Input_Full_Scale(ViSession instrSession, ViReal64 range_mV);
ViStatus _VI_FUNC AuMT8820_Get_AF_Input_Full_Scale(ViSession instrSession, ViReal64 _VI_FAR *range_mV);
ViStatus _VI_FUNC AuMT8820_Set_AF_Output_Full_Scale(ViSession instrSession, ViReal64 range_mV);
ViStatus _VI_FUNC AuMT8820_Get_AF_Output_Full_Scale(ViSession instrSession, ViReal64 _VI_FAR *range_mV);
ViStatus _VI_FUNC AuMT8820_Set_AICH_Condition_of_Returning_Acknowledge(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_AICH_Condition_of_Returning_Acknowledge(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_AICH_Transmission_Timing(ViSession instrSession, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_AICH_Transmission_Timing(ViSession instrSession, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Set_All_Fundamental_Measurement_Items_WCDMA(ViSession instrSession, ViChar *mode);
ViStatus _VI_FUNC AuMT8820_Get_All_Fundamental_Measurement_Items_WCDMA(ViSession instrSession,  ViChar  _VI_FAR mode[]);
ViStatus _VI_FUNC AuMT8820_Set_Audio_Input_Output_Connector_WCDMA(ViSession instrSession, ViInt32 connector);
ViStatus _VI_FUNC AuMT8820_Get_Audio_Input_Output_Connector_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *connector);
ViStatus _VI_FUNC AuMT8820_Set_Authentication_Key(ViSession instrSession, ViInt32 part, ViChar *value);
ViStatus _VI_FUNC AuMT8820_Get_Authentication_Key(ViSession instrSession, ViInt32 part, ViChar  *value);
ViStatus _VI_FUNC AuMT8820_Set_Authentication_Key_All(ViSession instrSession, ViChar *value1, ViChar *value2, ViChar *value3, ViChar *value4);
ViStatus _VI_FUNC AuMT8820_Get_Authentication_Key_All(ViSession instrSession, ViChar *value);
ViStatus _VI_FUNC AuMT8820_Set_AUX_External_Loss(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_AUX_External_Loss(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_AUX_External_Loss_On_Off(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_AUX_External_Loss_On_Off(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Adjacent_Channel_Power(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Adjacent_Channel_Power(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Frequency_Error_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Frequency_Error_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Modulation_Analysis_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Modulation_Analysis_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Occupied_Bandwidth_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Occupied_Bandwidth_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Peak_Code_Domain_Error_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Peak_Code_Domain_Error_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Power_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Power_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Average_Count_for_Spectrum_Emission_Mask_Measurement(ViSession instrSession, ViInt32 count);
ViStatus _VI_FUNC AuMT8820_Get_Average_Count_for_Spectrum_Emission_Mask_Measurement(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_AWGN_Output(ViSession instrSession, ViReal64 range_dB);
ViStatus _VI_FUNC AuMT8820_Get_AWGN_Output(ViSession instrSession, ViReal64 _VI_FAR *range_dB);
ViStatus _VI_FUNC AuMT8820_Set_AWGN_Output_Mode(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_AWGN_Output_Mode(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Base_Slot_Setup(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_Base_Slot_Setup(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Input_Data_Clock_Edge_WCDMA(ViSession instrSession, ViInt32 clock_Edge);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Input_Data_Clock_Edge_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *clock_Edge);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Input_Polarity_WCDMA(ViSession instrSession, ViInt32 polarity);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Input_Polarity_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *polarity);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Measurement_Input_WCDMA(ViSession instrSession, ViInt32 input);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Measurement_Input_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *input);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Measurement_Mode_WCDMA(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Measurement_Mode_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Number_Of_Samples_WCDMA(ViSession instrSession, ViInt32 samples);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Number_Of_Samples_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *samples);
ViStatus _VI_FUNC AuMT8820_Set_Bit_Error_Rate_Upper_Limit(ViSession instrSession, ViReal64 ratio);
ViStatus _VI_FUNC AuMT8820_Get_Bit_Error_Rate_Upper_Limit(ViSession instrSession, ViReal64 _VI_FAR *ratio);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Count_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *count);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Measurement_Mode_WCDMA(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Measurement_Mode_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Number_Of_Samples_WCDMA(ViSession instrSession, ViInt32 samples);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Number_Of_Samples_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *samples);
ViStatus _VI_FUNC AuMT8820_Set_Block_Error_Rate_Upper_Limit(ViSession instrSession, ViReal64 limit);
ViStatus _VI_FUNC AuMT8820_Get_Block_Error_Rate_Upper_Limit(ViSession instrSession, ViReal64 _VI_FAR *limit);
ViStatus _VI_FUNC AuMT8820_Set_Call_Drop(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Call_Drop(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Call_Processing(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Call_Processing(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Call_Threshold(ViSession instrSession, ViInt32 frame);
ViStatus _VI_FUNC AuMT8820_Get_Call_Threshold(ViSession instrSession, ViInt32 _VI_FAR *frame);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Average_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Average_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64  _VI_FAR *error);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Maximum_WCDMA(ViSession instrSession, ViInt32 unit,  ViReal64  _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Minimum_WCDMA(ViSession instrSession,  ViInt32 unit,  ViReal64  _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_Total_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64  _VI_FAR *average, ViReal64  _VI_FAR *maximum, ViReal64  _VI_FAR *minimum);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_Error_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Get_Carrier_Frequency_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Set_Cell_Identity(ViSession instrSession, ViInt32 iD);
ViStatus _VI_FUNC AuMT8820_Get_Cell_Identity(ViSession instrSession, ViChar _VI_FAR *iD);
ViStatus _VI_FUNC AuMT8820_Set_Cell_Selection_and_Reselection_Info(ViSession instrSession, ViInt32 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Cell_Selection_and_Reselection_Info(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Channel_Coding_Object(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Channel_Coding_Object(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_CPICH_Downlink(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_CPICH_Downlink(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_CPICH_Downlink_Power(ViSession instrSession, ViReal64 range_dB);
ViStatus _VI_FUNC AuMT8820_Get_CPICH_Downlink_Power(ViSession instrSession, ViReal64 _VI_FAR *range_dB);
ViStatus _VI_FUNC AuMT8820_Get_CPICH_Power_Ratio(ViSession instrSession, ViInt32 _VI_FAR *ratio_dB);
ViStatus _VI_FUNC AuMT8820_Get_CPICH_Power_Received(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_CPICH_Primary_TX_Power(ViSession instrSession, ViInt32 range_dBm);
ViStatus _VI_FUNC AuMT8820_Get_CPICH_Primary_TX_Power(ViSession instrSession, ViInt32 _VI_FAR *range_dBm);
ViStatus _VI_FUNC AuMT8820_Set_DCCH_Channelization_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_DCCH_Channelization_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_DCCH_Data_Pattern(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_DCCH_Data_Pattern(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Set_DCCH_Secondary_Scrambling_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_DCCH_Secondary_Scrambling_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Get_DCCH_Signaling(ViSession instrSession, ViReal64 _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Set_Digital_Traffic_Channel_Data_Pattern(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_Digital_Traffic_Channel_Data_Pattern(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Set_Display_Offset(ViSession instrSession, ViInt32 offset_dB);
ViStatus _VI_FUNC AuMT8820_Get_Display_Offset(ViSession instrSession, ViInt32 _VI_FAR *offset_dB);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_AICH(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_AICH(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_AICH_Channelization_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_AICH_Channelization_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_AICH_Power(ViSession instrSession, ViReal64 range);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_AICH_Power(ViSession instrSession, ViReal64 _VI_FAR *range);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_Channel(ViSession instrSession, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_Channel(ViSession instrSession, ViInt32 _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_Channel_Level_Unit(ViSession instrSession, ViInt32 object);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_Channel_Level_Unit(ViSession instrSession,  ViInt32  _VI_FAR *object);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_Frequency(ViSession instrSession, ViReal64 freq, ViInt32 units);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *freq);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_OCNS(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_OCNS_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_PCCPCH(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_PCCPCH(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_PCCPCH_Power(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_PCCPCH_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_PICH(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_PICH(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_PICH_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_PICH_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_PICH_Power(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_PICH_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_Primary_Scrambling_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_Primary_Scrambling_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_RAB_Rate_Maximum(ViSession instrSession, ViInt32 rate);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_RAB_Rate_Maximum(ViSession instrSession,  ViInt32  _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCCPCH(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCCPCH(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCCPCH_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCCPCH_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCCPCH_Power(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCCPCH_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCCPCH_Symbol_Rate(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCCPCH_Timing_Offset(ViSession instrSession, ViInt32 offset);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCCPCH_Timing_Offset(ViSession instrSession, ViInt32 _VI_FAR *offset);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCH(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCH(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Downlink_SCH_Power(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Downlink_SCH_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_DPCH_Downlink_Channel(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_DPCH_Downlink_Channel(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_DPCH_Downlink_Power(ViSession instrSession, ViReal64 range_dB);
ViStatus _VI_FUNC AuMT8820_Get_DPCH_Downlink_Power(ViSession instrSession, ViReal64 _VI_FAR *range_dB);
ViStatus _VI_FUNC AuMT8820_Get_DPCH_Downlink_Symbol_Rate(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_DPCH_Secondary_Scrambling_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_DPCH_Secondary_Scrambling_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_DPCH_Timing_Offset(ViSession instrSession, ViInt32 offset);
ViStatus _VI_FUNC AuMT8820_Get_DPCH_Timing_Offset(ViSession instrSession, ViInt32 _VI_FAR *offset);
ViStatus _VI_FUNC AuMT8820_Set_Encoder_Input_Gain_WCDMA(ViSession instrSession, ViReal64 gain_dB);
ViStatus _VI_FUNC AuMT8820_Get_Encoder_Input_Gain_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *gain_dB);
ViStatus _VI_FUNC AuMT8820_Get_Error_Vector_Magnitude(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Error_Vector_Magnitude_Average(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Error_Vector_Magnitude_Maximum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Error_Vector_Magnitude_Minimum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Error_Vector_Magnitude_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_percent, ViReal64 _VI_FAR *max_percent, ViReal64 _VI_FAR *min_percent);
ViStatus _VI_FUNC AuMT8820_Set_External_Loss_On_Off(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_External_Loss_On_Off(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_External_Down_Link_Loss_WCDMA(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_External_Down_Link_Loss_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_External_Up_Link_Loss_WCDMA(ViSession instrSession, ViReal64 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_External_Up_Link_Loss_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Filtered_Power(ViSession instrSession, ViInt32 units, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_Filtered_Power_Average(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_Filtered_Power_Maximum(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_Filtered_Power_Minimum(ViSession instrSession,  ViInt32 unit, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_Filtered_Power_Total(ViSession instrSession, ViInt32 unit, ViReal64  _VI_FAR *average, ViReal64  _VI_FAR *maximum, ViReal64  _VI_FAR *minimum);
ViStatus _VI_FUNC AuMT8820_Set_Frequency_Error_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Frequency_Error_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Frequency_Separation(ViSession instrSession, ViReal64 frequency_MHz);
ViStatus _VI_FUNC AuMT8820_Get_Frequency_Separation(ViSession instrSession, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Set_Fundamental_Measurement_Mode_WCDMA(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Fundamental_Measurement_Mode_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Handset_Microphone_Volume_WCDMA(ViSession instrSession, ViInt32 volume);
ViStatus _VI_FUNC AuMT8820_Get_Handset_Microphone_Volume_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *volume);
ViStatus _VI_FUNC AuMT8820_Set_Handset_Speaker_Volume_WCDMA(ViSession instrSession, ViInt32 volume);
ViStatus _VI_FUNC AuMT8820_Get_Handset_Speaker_Volume_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *volume);
ViStatus _VI_FUNC AuMT8820_Get_IMSI(ViSession instrSession, ViChar _VI_FAR identity[]);
ViStatus _VI_FUNC AuMT8820_Set_Int_Mobile_Sub_Identity_WCDMA(ViSession instrSession, ViChar iD[]);
ViStatus _VI_FUNC AuMT8820_Get_Int_Mobile_Sub_Identity_WCDMA(ViSession instrSession, ViChar _VI_FAR iD[]);
ViStatus _VI_FUNC AuMT8820_Get_Ior_Total_Power(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_IQ_Imbalance(ViSession instrSession, ViReal64 _VI_FAR *imbalance);
ViStatus _VI_FUNC AuMT8820_Get_IQ_Imbalance_Average(ViSession instrSession, ViReal64 _VI_FAR *imbalance);
ViStatus _VI_FUNC AuMT8820_Get_IQ_Imbalance_Maximum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_IQ_Imbalance_Minimum(ViSession instrSession, ViReal64 _VI_FAR *result);
ViStatus _VI_FUNC AuMT8820_Get_IQ_Imbalance_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_percent, ViReal64 _VI_FAR *max_percent, ViReal64 _VI_FAR *min_percent);
ViStatus _VI_FUNC AuMT8820_Set_Level_Continuous(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Level_Continuous(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_WCDMA(ViSession instrSession, ViInt32 iD);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_WCDMA(ViSession instrSession, ViChar iD[]);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_MCC_WCDMA(ViSession instrSession, ViInt32 iD);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_MCC_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *iD);
ViStatus _VI_FUNC AuMT8820_Get_Software_Version_WCDMA(ViSession instrSession, ViChar _VI_FAR *version);
ViStatus _VI_FUNC AuMT8820_Set_Location_ID_MNC_WCDMA(ViSession instrSession, ViInt32 iD);
ViStatus _VI_FUNC AuMT8820_Get_Location_ID_MNC_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *iD);
ViStatus _VI_FUNC AuMT8820_Set_Long_Span_Code_Search(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Long_Span_Code_Search(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Loopback_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Loopback_Mode(ViSession instrSession, ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Average_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Maximum_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Minimum_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_Total_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *avg_percent, ViReal64 _VI_FAR *max_percent, ViReal64 _VI_FAR *min_percent);
ViStatus _VI_FUNC AuMT8820_Get_Magnitude_Error_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Set_Marker_1_Mode(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Marker_1_Mode(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Marker_2_Mode(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Marker_2_Mode(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Marker_Position(ViSession instrSession, ViInt32 marker, ViReal64 position);
ViStatus _VI_FUNC AuMT8820_Get_Marker_Position(ViSession instrSession, ViInt32 marker,  ViReal64  *position);
ViStatus _VI_FUNC AuMT8820_Get_Marker_Relative_Level(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Marker_Relative_Slot(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Get_Marker_Relative_Time(ViSession instrSession, ViReal64 _VI_FAR *time);
ViStatus _VI_FUNC AuMT8820_Set_Marker_Type(ViSession instrSession, ViInt32 marker_Type);
ViStatus _VI_FUNC AuMT8820_Get_Marker_Type(ViSession instrSession,  ViInt32  _VI_FAR *marker_Type);
ViStatus _VI_FUNC AuMT8820_Set_Measurement_Object_WCDMA(ViSession instrSession, ViInt32 object);
ViStatus _VI_FUNC AuMT8820_Get_Measurement_Object_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *object);
ViStatus _VI_FUNC AuMT8820_Get_Measurement_Status_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Set_Mmax_Value_For_RACH_Parameter(ViSession instrSession, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_Mmax_Value_For_RACH_Parameter(ViSession instrSession, ViInt32 *number);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Marker(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Marker(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Marker_Level(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Marker_Position(ViSession instrSession, ViInt32 position);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Marker_Position(ViSession instrSession, ViInt32 _VI_FAR *position);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Storage_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Storage_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Vertical_Scale(ViSession instrSession, ViInt32 range);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Vertical_Scale(ViSession instrSession,  ViInt32  _VI_FAR *range);
ViStatus _VI_FUNC AuMT8820_Set_Modulation_Analysis_Waveform(ViSession instrSession, ViInt32 item);
ViStatus _VI_FUNC AuMT8820_Get_Modulation_Analysis_Waveform(ViSession instrSession,  ViInt32  _VI_FAR *item);
ViStatus _VI_FUNC AuMT8820_Set_NB01_Max(ViSession instrSession, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_NB01_Max(ViSession instrSession, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Set_NB01_Min(ViSession instrSession, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_NB01_Min(ViSession instrSession, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Set_Noise_Calibration_for_TDM(ViSession instrSession, ViInt32 switchmode);
ViStatus _VI_FUNC AuMT8820_Get_Noise_Calibration_for_TDM(ViSession instrSession,  ViInt32  _VI_FAR *switchmode);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth(ViSession instrSession, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Set_Occupied_Bandwidth_Detect_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth_Detect_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth_Frequency_Mode(ViSession instrSession, ViInt32 offset, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Set_Occupied_Bandwidth_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Occupied_Bandwidth_Ratio(ViSession instrSession, ViReal64 ratio);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth_Ratio(ViSession instrSession, ViReal64 _VI_FAR *ratio);
ViStatus _VI_FUNC AuMT8820_Set_Occupied_Bandwidth_Spectrum_Data(ViSession instrSession, ViInt32 position, ViInt32 _VI_FAR data);
ViStatus _VI_FUNC AuMT8820_Get_Occupied_Bandwidth_Spectrum_Data(ViSession instrSession, ViInt32 position, ViInt32 length, ViChar *data);
ViStatus _VI_FUNC AuMT8820_Get_Origin_Offset(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Origin_Offset_Average(ViSession instrSession, ViReal64 _VI_FAR *offset_dB);
ViStatus _VI_FUNC AuMT8820_Get_Origin_Offset_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Origin_Offset_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Origin_Offset_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_dB, ViReal64 _VI_FAR *max_dB, ViReal64 _VI_FAR *min_dB);
ViStatus _VI_FUNC AuMT8820_Set_Output_Level_WCDMA(ViSession instrSession, ViReal64 level, ViInt32 units);
ViStatus _VI_FUNC AuMT8820_Get_Output_Level_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Parameter_Items_Displayed_WCDMA(ViSession instrSession, ViInt32 tag, ViInt32 option);
ViStatus _VI_FUNC AuMT8820_Get_Parameter_Items_Displayed_WCDMA(ViSession instrSession, ViInt32 tag,  ViInt32  _VI_FAR *option);
ViStatus _VI_FUNC AuMT8820_Get_Path_Loss(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_PCCH_Signaling_RB(ViSession instrSession, ViReal64 _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Peak_Code_Domain_Error_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Code_Domain_Error_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_dB, ViReal64 _VI_FAR *max_dB, ViReal64 _VI_FAR *min_dB);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Vector_Error(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Vector_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Vector_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Vector_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *percent);
ViStatus _VI_FUNC AuMT8820_Get_Peak_Vector_Error_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_percent, ViReal64 _VI_FAR *max_percent, ViReal64 _VI_FAR *min_percent);
ViStatus _VI_FUNC AuMT8820_Set_Power_Control_Algorithm(ViSession instrSession, ViInt32 algorithm);
ViStatus _VI_FUNC AuMT8820_Get_Power_Control_Algorithm(ViSession instrSession,  ViInt32  _VI_FAR *algorithm);
ViStatus _VI_FUNC AuMT8820_Set_Power_Control_Bit_Pattern(ViSession instrSession, ViInt32 pattern);
ViStatus _VI_FUNC AuMT8820_Get_Power_Control_Bit_Pattern(ViSession instrSession,  ViInt32  _VI_FAR *pattern);
ViStatus _VI_FUNC AuMT8820_Set_Power_Measurement_Mode_WCDMA(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Power_Measurement_Mode_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Power_Offset_P0(ViSession instrSession, ViInt32 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Power_Offset_P0(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Preamble_Retrans_Max(ViSession instrSession, ViInt32 number);
ViStatus _VI_FUNC AuMT8820_Get_Preamble_Retrans_Max(ViSession instrSession, ViInt32 _VI_FAR *number);
ViStatus _VI_FUNC AuMT8820_Set_RAB_Channelization_Code(ViSession instrSession, ViInt32 range);
ViStatus _VI_FUNC AuMT8820_Get_RAB_Channelization_Code(ViSession instrSession, ViInt32 _VI_FAR *range);
ViStatus _VI_FUNC AuMT8820_Set_RACH_Constant_Value(ViSession instrSession, ViInt32 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_RACH_Constant_Value(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Register_Slot_Into_List(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_Register_Slot_Into_List(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Set_RF_Level_Output_Mode(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_RF_Level_Output_Mode(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_RF_Signal_Input_Level_WCDMA(ViSession instrSession, ViReal64 level_dBm);
ViStatus _VI_FUNC AuMT8820_Get_RF_Signal_Input_Level_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *level_dBm);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *degrees);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_Total_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *avg_deg, ViReal64 _VI_FAR *max_deg, ViReal64 _VI_FAR *min_deg);
ViStatus _VI_FUNC AuMT8820_Get_RMS_Phase_Vector_Error_WCDMA(ViSession instrSession, ViReal64 _VI_FAR *degree);
ViStatus _VI_FUNC AuMT8820_Set_RRC_Filter(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_RRC_Filter(ViSession instrSession,  ViInt32  _VI_FAR *setting);
//ViStatus _VI_FUNC AuMT8820_Set_RRC_Filtering_Mode(ViSession instrSession, ViInt32 mode);
//ViStatus _VI_FUNC AuMT8820_Get_RRC_Filtering_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_RX_Measure_Timeout(ViSession instrSession, ViInt32 seconds);
ViStatus _VI_FUNC AuMT8820_Get_RX_Measure_Timeout(ViSession instrSession, ViInt32 _VI_FAR *seconds);
ViStatus _VI_FUNC AuMT8820_Get_Rx_Measurement_Status_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Set_Screen_Select_WCDMA(ViSession instrSession, ViInt32 screen);
ViStatus _VI_FUNC AuMT8820_Get_Screen_Select_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *screen);
ViStatus _VI_FUNC AuMT8820_Set_Sequential_Output(ViSession instrSession, ViInt32 step_dB, ViInt32 length_frames, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Sequential_Output(ViSession instrSession, ViInt32 _VI_FAR *step_dB, ViInt32 _VI_FAR *length_frames, ViInt32 _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Sequential_Output_Frame(ViSession instrSession, ViInt32 step_dB);
ViStatus _VI_FUNC AuMT8820_Get_Sequential_Output_Frame(ViSession instrSession, ViInt32 _VI_FAR *step_dB);
ViStatus _VI_FUNC AuMT8820_Set_Sequential_Output_Length(ViSession instrSession, ViInt32 length_frames);
ViStatus _VI_FUNC AuMT8820_Get_Sequential_Output_Length(ViSession instrSession, ViInt32 _VI_FAR *length_frames);
ViStatus _VI_FUNC AuMT8820_Set_Sequential_Output_Mode(ViSession instrSession, ViInt32  mode);
ViStatus _VI_FUNC AuMT8820_Get_Sequential_Output_Mode(ViSession instrSession, ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Set_Cursor(ViSession instrSession, ViInt32 slot);
ViStatus _VI_FUNC AuMT8820_Get_Set_Cursor(ViSession instrSession, ViInt32 _VI_FAR *slot);
ViStatus _VI_FUNC AuMT8820_Set_Slot_List_Mode(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Slot_List_Mode(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Get_Slot_List_Total(ViSession instrSession, ViInt32 _VI_FAR *number);
//ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_ALL(ViSession instrSession, ViChar _VI_FAR *slots);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_Relative(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR slots[]);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_Slot_Level(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR level_dBm[]);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_Slot_Level_Relative(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR level_dB[]);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_Slot_Time(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR time_ms[]);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_Slot_Time_Relative(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR time_ms[]);
ViStatus _VI_FUNC AuMT8820_Get_Slot_Power_List_WCDMA(ViSession instrSession, ViInt32 slot, ViChar _VI_FAR *slots);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Detection_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Detection_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Limit(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Limit(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Marker_Frequency(ViSession instrSession, ViReal64 frequency);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Marker_Frequency(ViSession instrSession, ViReal64 _VI_FAR *frequency);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Marker_Level(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Marker_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Marker_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Measurement_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Measurement_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Template_Judgment(ViSession instrSession, ViInt32 _VI_FAR *judgement);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Template_Lower_Limit(ViSession instrSession, ViReal64 level_dBm);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Template_Lower_Limit(ViSession instrSession, ViReal64 _VI_FAR *level_dBm);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Mask_Template_Offset(ViSession instrSession, ViInt32 offset, ViReal64 level_dBc);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Mask_Template_Offset(ViSession instrSession, ViInt32 offset, ViReal64  _VI_FAR *level_dBc);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Emission_Spectrum_Data(ViSession instrSession, ViInt32 position, ViInt32 _VI_FAR data);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Emission_Spectrum_Data(ViSession instrSession, ViInt32 position, ViInt32 length, ViChar _VI_FAR *data);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Detection_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Detection_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Display_Offset(ViSession instrSession, ViInt32 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Display_Offset(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Frequency_Span(ViSession instrSession, ViInt32 span);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Frequency_Span(ViSession instrSession, ViInt32 _VI_FAR *span);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Marker_Position(ViSession instrSession,  ViChar _VI_FAR frequency[]);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Marker_Position(ViSession instrSession,  ViChar _VI_FAR frequency[]);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Normal_Marker_Level(ViSession instrSession, ViInt32 number, ViReal64 _VI_FAR *level_dBm);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Zone_Marker(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Zone_Marker(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Zone_Marker_Frequency(ViSession instrSession, ViReal64 _VI_FAR frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Zone_Marker_Frequency(ViSession instrSession, ViReal64 _VI_FAR *frequency_Hz);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Zone_Marker_Level(ViSession instrSession, ViReal64 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Spectrum_Monitor_Zone_Marker_Position(ViSession instrSession, ViReal64 frequency_MHz);
ViStatus _VI_FUNC AuMT8820_Get_Spectrum_Monitor_Zone_Marker_Position(ViSession instrSession, ViReal64 _VI_FAR *frequency_MHz);
ViStatus _VI_FUNC AuMT8820_Set_Sync_Marker_1_and_2(ViSession instrSession, ViInt32 setting);
ViStatus _VI_FUNC AuMT8820_Get_Sync_Marker_1_and_2(ViSession instrSession,  ViInt32  _VI_FAR *setting);
ViStatus _VI_FUNC AuMT8820_Set_Synchronous_Single_Sweep_WCDMA(ViSession instrSession);
ViStatus _VI_FUNC AuMT8820_Get_Synchronous_Single_Sweep_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Set_Tag_Select_WCDMA(ViSession instrSession, ViInt32 tag);
ViStatus _VI_FUNC AuMT8820_Get_Tag_Select_WCDMA(ViSession instrSession, ViInt32 window,  ViInt32  _VI_FAR *tag);
ViStatus _VI_FUNC AuMT8820_Set_Template_Open_WCDMA(ViSession instrSession, ViInt32 template);
ViStatus _VI_FUNC AuMT8820_Get_Template_Open_WCDMA(ViSession instrSession, ViInt32  _VI_FAR *template);
ViStatus _VI_FUNC AuMT8820_Get_Time_Domain_Marker_Level(ViSession instrSession, ViInt32 marker, ViReal64 _VI_FAR *level_dBm);
ViStatus _VI_FUNC AuMT8820_Set_Time_Span(ViSession instrSession, ViReal64 milliseconds);
ViStatus _VI_FUNC AuMT8820_Get_Time_Span(ViSession instrSession, ViReal64 _VI_FAR *milliseconds);
ViStatus _VI_FUNC AuMT8820_Set_Timeout_Length(ViSession instrSession, ViInt32 seconds);
ViStatus _VI_FUNC AuMT8820_Get_Timeout_Length(ViSession instrSession, ViInt32 _VI_FAR *seconds);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Error(ViSession instrSession, ViReal64 _VI_FAR *chips);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Error_Average(ViSession instrSession, ViReal64 _VI_FAR *chip);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Error_Maximum(ViSession instrSession, ViReal64 _VI_FAR *chip);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Error_Minimum(ViSession instrSession, ViReal64 _VI_FAR *chip);
ViStatus _VI_FUNC AuMT8820_Get_Timing_Error_Total(ViSession instrSession, ViReal64 _VI_FAR *avg_chip, ViReal64 _VI_FAR *max_chip, ViReal64 _VI_FAR *min_chip);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Command(ViSession instrSession, ViInt32 term, ViChar *bit);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Command(ViSession instrSession, ViInt32 term, ViChar _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Command_All(ViSession instrSession, ViChar *bit);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Command_All(ViSession instrSession, ViChar _VI_FAR *bit);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Command_Length(ViSession instrSession, ViInt32 method, ViInt32 length);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Command_Length(ViSession instrSession, ViInt32 method, ViInt32 _VI_FAR *length);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Command_Mode(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Command_Mode(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Command_Type(ViSession instrSession, ViInt32 method, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Command_Type(ViSession instrSession, ViInt32 method,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Step_Size(ViSession instrSession, ViInt32 step);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Step_Size(ViSession instrSession,  ViInt32  _VI_FAR *step);
ViStatus _VI_FUNC AuMT8820_Set_TPC_Test_Step(ViSession instrSession, ViInt32 step);
ViStatus _VI_FUNC AuMT8820_Get_TPC_Test_Step(ViSession instrSession,  ViInt32  _VI_FAR *step);
ViStatus _VI_FUNC AuMT8820_Set_TPC_User_Command(ViSession instrSession, ViInt32 part, ViChar *command);
ViStatus _VI_FUNC AuMT8820_Get_TPC_User_Command(ViSession instrSession, ViInt32 part, ViChar *command);
ViStatus _VI_FUNC AuMT8820_Set_TPC_User_Command_All(ViSession instrSession, ViChar *command);
ViStatus _VI_FUNC AuMT8820_Get_TPC_User_Command_All(ViSession instrSession,  ViChar *command);
ViStatus _VI_FUNC AuMT8820_Set_Trigger_Delay(ViSession instrSession, ViReal64 milliseconds);
ViStatus _VI_FUNC AuMT8820_Get_Trigger_Delay(ViSession instrSession, ViReal64 _VI_FAR *milliseconds);
ViStatus _VI_FUNC AuMT8820_Set_Trigger_Source(ViSession instrSession, ViInt32 trigger);
ViStatus _VI_FUNC AuMT8820_Get_Trigger_Source(ViSession instrSession,  ViInt32  _VI_FAR *trigger);
ViStatus _VI_FUNC AuMT8820_Get_Tx_Measurement_Status_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *status);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Average_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *power);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Level_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Maximum_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Minimum_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Get_TX_Power_Total_WCDMA(ViSession instrSession, ViInt32 unit, ViReal64  _VI_FAR *average, ViReal64  _VI_FAR *maximum, ViReal64  _VI_FAR *minimum);
ViStatus _VI_FUNC AuMT8820_Get_UE_Power_Class(ViSession instrSession, ViInt32 _VI_FAR *class);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_Channel_WCDMA(ViSession instrSession, ViInt32 channel);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_Channel_WCDMA(ViSession instrSession, ViInt32 _VI_FAR *channel);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_DPCH_Scrambling_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_DPCH_Scrambling_Code(ViSession instrSession, ViChar _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_DPCH_Scrambling_Code_Type(ViSession instrSession, ViInt32 type);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_DPCH_Scrambling_Code_Type(ViSession instrSession,  ViInt32  _VI_FAR *type);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_DPCH_Symbol_Rate(ViSession instrSession, ViInt32 _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_External_Loss(ViSession instrSession, ViInt32 mode);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_External_Loss(ViSession instrSession,  ViInt32  _VI_FAR *mode);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_Frequency(ViSession instrSession, ViInt32 units, ViReal64 freq);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_Frequency(ViSession instrSession, ViReal64 _VI_FAR *freq);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_Interference(ViSession instrSession, ViInt32 level_dB);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_Interference(ViSession instrSession, ViInt32 _VI_FAR *level_dB);
ViStatus _VI_FUNC AuMT8820_Set_Uplink_PRACH_Scrambling_Code(ViSession instrSession, ViInt32 code);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_PRACH_Scrambling_Code(ViSession instrSession, ViInt32 _VI_FAR *code);
ViStatus _VI_FUNC AuMT8820_Get_Uplink_PRACH_Symbol_Rate(ViSession instrSession, ViReal64 _VI_FAR *rate);
ViStatus _VI_FUNC AuMT8820_Set_URA_Identity(ViSession instrSession, ViInt32 iD);
ViStatus _VI_FUNC AuMT8820_Get_URA_Identity(ViSession instrSession, ViChar _VI_FAR *iD);
ViStatus _VI_FUNC AuMT8820_Set_Video_Filter_Length(ViSession instrSession, ViReal64 length_us);
ViStatus _VI_FUNC AuMT8820_Get_Video_Filter_Length(ViSession instrSession, ViReal64 _VI_FAR *length_us);
//ViStatus _VI_FUNC AuMT8820_Set_Video_Trigger_Treshold(ViSession instrSession, ViInt32 level);
//ViStatus _VI_FUNC AuMT8820_Get_Video_Trigger_Treshold(ViSession instrSession, ViInt32 _VI_FAR *level);
ViStatus _VI_FUNC AuMT8820_Set_View_Window_Open(ViSession instrSession, ViInt32 view);
ViStatus _VI_FUNC AuMT8820_Get_View_Window_Open(ViSession instrSession,  ViInt32  _VI_FAR *view);
ViStatus _VI_FUNC AuMT8820_Set_Voice_Channel(ViSession instrSession, ViInt32 subflow);
ViStatus _VI_FUNC AuMT8820_Get_Voice_Channel(ViSession instrSession,  ViInt32  _VI_FAR *subflow);
ViStatus _VI_FUNC AuMT8820_Set_Voltage_Display_WCDMA(ViSession instrSession, ViInt32 unit);
ViStatus _VI_FUNC AuMT8820_Get_Voltage_Display_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *unit);
ViStatus _VI_FUNC AuMT8820_Set_Window_Size_WCDMA(ViSession instrSession, ViInt32 size);
ViStatus _VI_FUNC AuMT8820_Get_Window_Size_WCDMA(ViSession instrSession,  ViInt32  _VI_FAR *size);


#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
